package servercore.job;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import java.util.zip.GZIPOutputStream;

import servercore.data.Cookie;
import servercore.data.HtmlParam;
import servercore.http.HttpRequest;
import servercore.http.HttpServer;
import servercore.http.HttpResponse;
import lib.io.ByteUtil;
import lib.io.ExtendFile;

public class JobWorker {
	public void execute(OutputStream ops, InputStream ips) throws IOException {
		HttpRequest req = analyzeReq(ips);
		req.normarizePath(HttpServer.getRootDirPath());
		String ext = req.getExtesion();

		// レスポンスを圧縮(gzip)して送信するか
		boolean useGzip = useEncodingOK(req.getHeader().get("Accept-Encoding"),
				HttpServer.getUseCompress());


		System.out.print(req.getMethod() + "\t" + req.getRowPath() + "\t");

		HttpResponse res = null;
		if(HttpServer.useSecurity()) {
			res = security(req);
			if(res.getStatusCore() == 200) {
				res = GeneratePage.execute(req, ops, ips);
			}
		} else {
			res = GeneratePage.execute(req, ops, ips);
		}

		String resStr = "";
		String CrtDate = editTimeZone(System.currentTimeMillis());
		String LastMod = editTimeZone(res.getLastModified());
		if(res.getStatusCore() == 200) {
			resStr += "HTTP/1.1 200 OK\r\n";
			if(useGzip && (ext.equals("html") || ext.equals("htm")|| ext.equals("do"))) {
				try {
					ByteArrayOutputStream baos = new ByteArrayOutputStream();
					GZIPOutputStream gos = new GZIPOutputStream(baos);
					byte[] content = res.getResponseByte();
					for(int i=0; i<content.length; i++){
						gos.write(content[i]);
					}
					gos.close();
					byte[] gzip_content = baos.toByteArray();
					baos.close();
					res.setResponseByte(gzip_content);
					System.out.print(" gzip ");
				} catch(IOException ioe) {
					ioe.printStackTrace();
					useGzip = false;
				}
			} else {
				useGzip = false;
			}

		} else if(res.getStatusCore() == 201) {
			resStr += "HTTP/1.1 201 Created\r\n";
		} else if(res.getStatusCore() == 204) {
			resStr += "HTTP/1.1 204 No Content\r\n";
		} else if(res.getStatusCore() == 301) {
			resStr += "HTTP/1.1 301 Moved Permanently\r\n";
		} else if(res.getStatusCore() == 403) {
			resStr += "HTTP/1.1 403 Fobbiden\r\n";
		} else if(res.getStatusCore() == 404) {
			resStr += "HTTP/1.1 404 Not found\r\n";
		} else if(res.getStatusCore() == 500) {
			resStr += "HTTP/1.1 500 Internal sever error\r\n";
		}
		System.out.println(res.getStatusCore());
		resStr += "Date: " + CrtDate + " GMT\r\n";
		resStr += "Last-Modified: " + LastMod + " GMT\r\n";
		resStr += "ETag:\"45aa-707-3c19898c\"r\n";
		resStr += "Accept-Ranges: bytes\r\n";
		resStr += "Content-Length: " + res.getContentLength() + "\r\n";
		if(res.getHeader() != null) {
			HashMap<String, String> map = res.getHeader();
			for(String key:map.keySet()) {
				String value = map.get(key);
				resStr += key + ": " + value + "\r\n";
			}
		}
		//resStr += "Connection: Keep-Alive\r\n";

		// ファイルの拡張子を判断
		if (ext.equals("jpg")) {
			resStr += "Content-Type: image/jpeg\r\n";
		} else if(ext.equals("png")) {
			resStr += "Content-Type: image/png\r\n";
		} else if(ext.equals("css")) {
			resStr += "Content-Type: text/css\r\n";
		} else if(ext.equals("js")) {
			resStr += "Content-Type: text/javascript\r\n";
		} else if(ext.equals("html") || ext.equals("htm")|| ext.equals("do")) {
			resStr += "Content-Type: text/html\r\n";
		} else {
			resStr += "Content-Type: text/plain\r\n";
		}

		// gzip圧縮
		if(useGzip && res.getStatusCore() == 200) {
			resStr += "Content-Encoding: gzip\r\n";
		}

		resStr += "\r\n";

		ops.write(resStr.getBytes());
		ops.write(res.getResponseByte());

	}
	public HttpRequest analyzeReq(InputStream ips) throws IOException {
		HttpRequest req = new HttpRequest();
		//ClientJob job = new ClientJob();
		// リクエストの受信
		byte[] recvByte = new byte[10000];
		int recvByteNum = ips.read(recvByte);
		if(recvByteNum < 0) {
			return null;
		}
		byte[] headerRowBytes = new byte[recvByteNum];
		System.arraycopy(recvByte, 0, headerRowBytes, 0, recvByteNum);
		req.headerBytes = headerRowBytes;
		String firstLine = new String(recvByte, 0, recvByteNum);

		firstLine = firstLine.replaceAll("\\r\\n\\r\\n", "\r\n \r\n");
		String[] allLines = firstLine.split("\\r\\n");
		String[] first_chars = allLines[0].split(" ");

		req.setRequestMethod(first_chars[0]);
		boolean finished = false;
		String postData = null;
		HashMap<String, String> header = new HashMap<String, String>();
		for(int i = 1;i < allLines.length;i++) {
			String line = allLines[i];
			if(" ".equals(line)) {
				if(req.getMethod() == HttpRequest.METHOD.GET) {
					finished = true;
					break;
				} else if(req.getMethod() == HttpRequest.METHOD.POST) {
					// POSTで最終行の場合データ部を受信していない
					if(i == (allLines.length - 1)) {
						break;
					} else {
						postData = allLines[i + 1];
						finished = true;
						break;
					}
				} else {
					finished = true;
					break;
				}
			} else {
				String[] set = line.split("\\: ");
				if(set != null && set.length == 2) {
					header.put(set[0], set[1]);
				}
			}
		}
		if(!finished) {
			recvByteNum = ips.read(recvByte);
			if(recvByteNum >= 0) {
				postData = new String(recvByte, 0, recvByteNum);
			}
		}
		if(postData != null) {
			req.setPostParams(HtmlParam.analyze(postData));
		}
		req.setPath(first_chars[1]);
		req.setHeader(header);
		req.setCookieValues(setCookie(req.getHeader().get("Cookie")));
		return req;
	}
	public HttpResponse security(HttpRequest req) {
		HttpResponse res = new HttpResponse();
		String path = req.getRowPath();
		if("/login_form.html".equals(path)) {
			res.setStatusCore(200);
			return res;
		}
		if("/js/jquery.js".equals(path)) {
			res.setStatusCore(200);
			return res;
		}
		if("/LoginCheck.do".equals(path)) {
			res.setStatusCore(200);
			return res;
		}
		String cookieKey = req.getCookieValues().get("SESSIONID");
		Cookie cookie = SessionCheck.getCookie(cookieKey);
		if(cookie != null) {
			res.setStatusCore(200);
			return res;
		} else {
			res.setStatusCore(301);
			res.addHeader("Cache-Control", "no-cache");
			res.addHeader("Location", "/login_form.html");
		}

		return res;
	}
	public HashMap<String, String> setCookie(String str) {
		HashMap<String, String> cookieValue = new HashMap<String, String>();
		if(str == null) {
			return cookieValue;
		}

		String[] values = str.split("\\;");
		for(String set:values) {
			set = set.trim();
			String[] sets = set.split("\\=");
			if(sets != null && sets.length == 2) {
				cookieValue.put(sets[0], sets[1]);
			}
		}
		return cookieValue;
	}
	public String parsePath (String rowPath) {
		int index = rowPath.indexOf('?');
		if(index < 0) {
			return rowPath;
		}
		return rowPath.substring(0, index);
	}
	/**
	 * システム日付をHTTPヘッダ用に書式編集する
	 */
	public String editTimeZone(long milliSecound) {
		SimpleDateFormat sdf;
		sdf = new SimpleDateFormat("EEE d MMM yyyy HH mm ss", Locale.US);
		String editedDate = sdf.format(new Date(milliSecound));
		return editedDate;
	}

	public boolean useEncodingOK(String accept_encoding, String encode_algo) {
		if(accept_encoding == null || encode_algo == null || "".equals(encode_algo)) {
			return false;
		}
		return accept_encoding.indexOf(encode_algo) >= 0;
	}
}
